const common = require('./helpers/common.js');
const db = require('./helpers/db.js');
const settings = require('./helpers/settings.js');
const registration = require('./helpers/registration.js');

describe('Installation recovery', () => {
  before(async () => {
    await db.reset();
    await db.activate({
      skipRegistration: true
    });
    await common.login();
  });

  it('should notify invalid install key used', async () => {
    await common.goTo('wp-admin/admin.php?page=trinity_audio');
    await registration.termsCheckbox.click();
    await registration.buttonSubmit.click();

    await checkTexts();

    await registration.installKeyInput.setValue('INVALID_INSTALL_KEY');
    await registration.buttonSubmit.click();

    await registration.errorNotificationWaitExist(2);

    expect(await registration.errorNotificationText[1]).toBe('We can see that the following value has changed in your database wp_options.trinity_audio_installkey. If you know how to revert the change, please do. If not, please write to us at wp@trinityaudio.ai and we will respond as fast as we can.');
  });

  it('should be successful', async () => {
    await common.goTo('wp-admin/admin.php?page=trinity_audio');
    await registration.termsCheckbox.click();
    await registration.buttonSubmit.click();

    await checkTexts();

    await registration.installKeyInput.setValue(common.INSTALL_KEY);
    await registration.buttonSubmit.click();

    await settings.buttonSave.waitForExist();
    await settings.buttonSave.scrollIntoView();
    await settings.buttonSave.click();

    expect(await settings.titleMain.getText()).toBe('TRINITY AUDIO');
  });

  async function checkTexts() {
    await registration.errorNotificationWaitExist();

    expect(await registration.errorNotificationText).toMatchObject([
      `It seems like your site ${common.host} is already registered to our services. In order to protect your assets, we do not allow duplicated registrations.\nIf you've registered before and migrated into a new database/hosting service - please use the form below to insert the Install Key if you have one, otherwise contact us at wp@trinityaudio.ai to help resolve this issue.`
    ]);

    expect(await registration.recoveryTitleText).toBe('Site migration/re-install');

    expect(await registration.recoveryDescriptionText).toMatchObject([
      'If you\'ve registered before and are now migrating to a new database or hosting service, please insert your previous Install Key.',
      'Your install key can be found in your previous admin panel, under Trinity Audio -> Info -> Install key.'
    ]);
  }
});
