const common = require('./helpers/common.js');
const db = require('./helpers/db.js');
const network = require('./helpers/network.js');
const player = require('./helpers/player.js');
const postMenu = require('./helpers/post-menu.js');

describe('Post menu', () => {
  before(async () => {
    await db.reset();
    await db.register();
  });

  it('should pass default settings', async () => {
    await common.goTo('?p=1&TRINITY_TEST_QP=1');
    await player.switchToFrame();
    await player.playButton.click();

    await browser.pause(500);

    await network.checkTrinityProcessParams({
      language: 'en-US',
      voiceGender: 'f'
    });
  });

  it('should pass changed settings', async () => {
    await common.login();
    await common.goTo('wp-admin/post.php?post=1&action=edit');

    await postMenu.closeWelcomeDialog();

    await postMenu.selectGender.selectByVisibleText('Male');
    await postMenu.selectLanguage.selectByVisibleText('English (United Kingdom)');

    await postMenu.buttonPublish.click();

    await browser.pause(500);

    await common.goTo('?p=1&TRINITY_TEST_QP=1');
    await player.switchToFrame();
    await player.playButton.click();

    await browser.pause(500);

    await network.checkTrinityProcessParams({
      language: 'en-GB',
      voiceGender: 'm'
    });
  });

  it('should disable the player', async () => {
    await common.goTo('?p=1');
    await player.iframe.waitForExist();

    await common.login();
    await common.goTo('wp-admin/post.php?post=1&action=edit');

    await postMenu.closeWelcomeDialog();

    await postMenu.checkboxEnableTTS.click();
    await postMenu.buttonPublish.click();
    await postMenu.buttonGoToPost.click();

    expect(await player.iframe.isExisting()).toBeFalsy();
  });
});
