const common = require('./common.js');

module.exports = {
  get buttonSubmit() {
    return $('.register button');
  },

  get errorNotificationBlock() {
    return $('.registration-error');
  },

  errorNotificationWaitExist(childNumber = 1) {
    return this.errorNotificationBlock.$(`.notice:nth-child(${childNumber}) p`).waitForExist();
  },

  get errorNotificationText() {
    return this.errorNotificationBlock.$$('.notice p').map((e) => e.getText());
  },

  get installKeyInput() {
    return $('#TRINITY_AUDIO_RECOVER_INSTALLKEY');
  },

  get recoveryBlock() {
    return $('.recover-install-key');
  },

  get recoveryTitleText() {
    return this.recoveryBlock.$('.site-migration').getText();
  },

  get recoveryDescriptionText() {
    return this.recoveryBlock.$$('.description').map((e) => e.getText());
  },

  get termsCheckbox() {
    return $('[name="trinity_audio_terms_of_service"] + .custom-hitbox');
  },

  async register() {
    await common.goTo('wp-admin/admin.php?page=trinity_audio');
    await this.termsCheckbox.click();
    await this.buttonSubmit.click();
  }
};
