module.exports = {
  get buttonDialogClose() {
    return $('[aria-label="Close dialog"]');
  },

  get buttonGoToPost() {
    return $('.components-snackbar__action.is-tertiary');
  },

  get buttonPublish() {
    return $('button.editor-post-publish-button');
  },

  get checkboxEnableTTS() {
    return $('#trinity_audio_enable');
  },

  async closeWelcomeDialog() {
    try {
      await this.buttonDialogClose.waitForExist({
        timeout: 500
      });
    } catch (e) {
      // muted
    }

    if (await this.buttonDialogClose.isExisting()) {
      await this.buttonDialogClose.click();
    }
  },

  get selectGender() {
    return $('#trinity_audio_gender_id');
  },

  get selectLanguage() {
    return $('#trinity_audio_source_language');
  }
};
