const common = require('./common.js');

const WAIT_FOR_PLAY_START = 5000;

module.exports = {
  get iframe() {
    return $('iframe.trinity-iframe.trinity-player.loaded');
  },

  get playButton() {
    return $('button.button-play');
  },

  get title() {
    return $('.trinity-player .title');
  },

  get titleText() {
    return this.title.$('span').getText();
  },

  async switchToFrame() {
    await this.iframe.waitForExist();
    return common.switchToFrame(this.iframe);
  },

  async waitTitleChange(title, timeout = WAIT_FOR_PLAY_START) {
    const callback = async () => await this.titleText === title;
    const options = {
      timeout,
      timeoutMsg: `Current title: "${await this.title}" has not changed to expected title: "${title}" in ${timeout}ms`
    };

    await browser.waitUntil(callback, options);
  }
};
