module.exports = {
  async getNetworkURLs(filter, skipEvents) {
    if (!skipEvents) skipEvents = ['heartBeat'];

    return browser.execute((innerFilter, innerSkipEvents) => {
      function _include(str, what) {
        for (let i = 0; i < what.length; ++i) {
          if (str.includes(what[i])) return true;
        }
      }

      let result = window.performance.getEntriesByType('resource').map((v) => v.name);

      if (innerFilter) result = result.filter((v) => v.startsWith(innerFilter) && !_include(v, innerSkipEvents));

      return result;
    }, filter, skipEvents);
  },

  async checkTrinityProcessParams(expectedProps) {
    const urls = await this.getNetworkURLs([
      'https://dev-sas.site/player/process'
    ]);

    expect(urls.length).toBeGreaterThan(0);

    const result = this.isAllParamsMatched(urls.at(-1), expectedProps);

    expect(result).toBeTruthy();
  },

  isAllParamsMatched(url, expectedProps) {
    const urlObject = new URL(url);

    return Object.keys(expectedProps).every((propName) => urlObject.searchParams.get(propName) === expectedProps[propName]);
  }
};
