/*
  REQUIREMENT:
  mysql cli tools had to be installed
*/
const util = require('util');
const childProcess = require('child_process');

const exec = util.promisify(childProcess.exec);

module.exports = {
  async reset() {
    await execCommand('$(pwd)/scripts/db_conf_clear.sh', 'Clearing conf db');
    await execCommand('$(pwd)/scripts/db_conf_seed.sh', 'Seeding conf db');
    await execCommand('$(pwd)/scripts/db_wp_restore.sh', 'Refreshing wp db');
    await execCommand('$(pwd)/scripts/redis_clear.sh', 'Clearing Redis');
    await execCommand('$(pwd)/scripts/redis_update.sh', 'Updating Redis');
  },

  async activate({skipRegistration} = {}) {
    let params = '';

    if (skipRegistration) params += ' --skip-reg';

    await execCommand(`$(pwd)/scripts/db_plugin_activate.sh${params}`, `Activating plugin${params}`);
  },

  /**
   * In order to skip long registration flow over UI
   */
  async register() {
    await this.activate();
    await execCommand('$(pwd)/scripts/redis_update.sh register', 'Emulating registration Redis');
  }
};

async function execCommand(command, label) {
  console.info(label);
  try {
    const {stdout, stderr} = await exec(command);

    if (stdout) console.info('stdout', stdout);
    if (stderr) console.error('stderr', stderr);
  } catch (error) {
    console.error(`Error executing ${command}`, error);
  }
}
