const common = require('./helpers/common.js');
const db = require('./helpers/db.js');
const settings = require('./helpers/settings.js');
const player = require('./helpers/player.js');
const postMenu = require('./helpers/post-menu.js');
const registration = require('./helpers/registration.js');

const FIRST_TIME_INSTALL_TRANSIENT_TIMEOUT = 60 * 1000;

describe('Basic', () => {
  before(async () => {
    await db.reset();
  });

  it('should register and render the player', async () => {
    await common.activate();
    await registration.register();
    await settings.save();

    await common.goTo('wp-admin/post.php?post=1&action=edit');

    await postMenu.closeWelcomeDialog();

    await postMenu.buttonPublish.click();
    await postMenu.buttonGoToPost.click();

    // wait for WP plugin set_transient first time install
    await browser.pause(FIRST_TIME_INSTALL_TRANSIENT_TIMEOUT);
    await browser.refresh();

    await player.switchToFrame();

    expect(await player.titleText).toBe('Listen to this article now');
  });

  it('should play back the audio', async () => {
    await db.register();
    await common.goTo('?p=1');
    await player.switchToFrame();

    expect(await player.titleText).toBe('Listen to this article now');

    await player.playButton.click();
    await player.waitTitleChange('Playing article');
  });
});
