const common = require('./helpers/common.js');
const db = require('./helpers/db.js');
const settings = require('./helpers/settings.js');

const PREMIUM_PUBLISHER_ACCOUNT_KEY = '1238246448cc0ed784e8b47cd2d4c89a';

describe('Account key activation', () => {
  before(async () => {
    await db.reset();
    await db.register();
    await common.login();
  });

  it('should not activate with wrong account key', async () => {
    await common.goTo('wp-admin/admin.php?page=trinity_audio');

    await settings.inputAccountKey.scrollIntoView();
    await settings.inputAccountKey.setValue('INCORRECT_ACCOUNT_KEY');

    await settings.buttonSaveAccountKey.click();

    await settings.notificationAccountKey.waitForExist();

    expect(await settings.notificationAccountKey.getText()).toBe('Account Key is not found - please verify you have the correct one. If the problem persists, please write to us at wp@trinityaudio.ai and we will respond as fast as we can.');
  });

  it('should activate successfully', async () => {
    await common.goTo('wp-admin/admin.php?page=trinity_audio');

    await settings.inputAccountKey.scrollIntoView();
    await settings.inputAccountKey.setValue(PREMIUM_PUBLISHER_ACCOUNT_KEY);

    await settings.buttonSaveAccountKey.click();

    expect(await settings.verifiedMessageText).toBe('Account key Validated');
    expect(await settings.inputAccountKey.getAttribute('disabled')).toBeTruthy;
  });
});
