#!/bin/bash
set -ex

echo "Starting E2E testing setup"

export ENV_SUFFIX=${ENV_SUFFIX:-""}
export NETWORK_NAME="trinity-wp${ENV_SUFFIX}"

export DB_HOST="conf-db-test${ENV_SUFFIX}"
export DB_USER="root"
export DB_PASS="root"
export DB_PORT=3306
export DB_NETWORK="conf-db-test"
export DB_SCHEMA_WP=wp

export REDIS_IMAGE="redis:5.0.7"
export REDIS_MASTER_NAME="wp-redis${ENV_SUFFIX}"
export REDIS_SLAVE_NAME="wp-redis-slave${ENV_SUFFIX}"

export R2V2_IMAGE="memeglobal/r2v2:prod"
export R2V2_NAME="wp-r2v2${ENV_SUFFIX}"

export SERGIO_IMAGE="memeglobal/sergio:prod"
export SERGIO_NAME="wp-sergio${ENV_SUFFIX}"
export SERGIO_PORT=8080
export SERGIO_URL="http://$SERGIO_NAME:$SERGIO_PORT"

export WP_IMAGE="wordpress"
export WP_NAME="wp-plugin-e2e${ENV_SUFFIX}"

export DEV_SAS_IMAGE="memeglobal/dev-sas:latest-trinity-player"
export DEV_SAS_NAME="wp-dev-sas${ENV_SUFFIX}"
export TRINITY_URL="http://dev-sas.site/player/trinity/"

export SELENIUM_IMAGE="memeglobal/selenium-node:chrome99-node16"
export SELENIUM_NAME="wp-selenium${ENV_SUFFIX}"

trap 'catch $? $LINENO' EXIT
catch() {
  if [ "$1" != "0" ]; then
    echo "Exception caught"

    docker ps -a

    # cat ../logs/*.log

    # echo ------- $SELENIUM_NAME ------- 

    # docker inspect $SELENIUM_NAME -f "{{json .NetworkSettings.Networks }}"

    # echo ------- $WP_NAME -------

    # docker inspect $WP_NAME -f "{{json .NetworkSettings.Networks }}"

    # docker logs $WP_NAME

    # echo ------- $SERGIO_NAME -------

    # docker inspect $SERGIO_NAME -f "{{json .Config }}"

    # docker inspect $SERGIO_NAME -f "{{json .NetworkSettings.Networks }}"

    # docker logs $SERGIO_NAME

    # echo ------- $R2V2_NAME -------

    # docker inspect $R2V2_NAME -f "{{json .Config }}"

    # docker inspect $R2V2_NAME -f "{{json .NetworkSettings.Networks }}"

    # docker logs $R2V2_NAME

    # echo ------- $DB_HOST -------

    # docker inspect $DB_HOST -f "{{json .NetworkSettings.Networks }}"

    # docker exec $DB_HOST mysql -u $DB_USER -p$DB_PASS data -e "SELECT avc_id, avc_campaignId, avc_unitName, avc_installkey, avc_viewkey FROM audioVoiceConfig;";

    # docker logs $DB_HOST

    # echo ------- $DEV_SAS_NAME -------
    # docker exec $DEV_SAS_NAME bash -c "cat /etc/hosts"

    # docker exec $DEV_SAS_NAME bash -c "yum install -y curl redis && curl https://local-vd.dev-sas.site/tts-player/dist/trinity-injector-script.js"

    # docker exec $DEV_SAS_NAME bash -c "redis-cli -h redis hgetall audioVoiceConfig_viewkey"

    # docker exec $DEV_SAS_NAME bash -c "redis-cli -h redis hgetall settings"

    # echo --------------------------

    ./scripts/run_docker_cleanup.sh

    exit 1
  fi
}

./scripts/run_docker_cleanup.sh

docker network create ${NETWORK_NAME} | true

./scripts/run_conf_db.sh
./scripts/run_redis.sh
./scripts/run_r2v2.sh
./scripts/run_sergio.sh
./scripts/run_trinity.sh
./scripts/run_wp.sh
./scripts/run_selenium.sh

./scripts/run_docker_cleanup.sh

echo "Done successfully"
