#!/bin/bash
set -ex

echo "******************************"
echo " Starting local setup"
echo "******************************"

export NETWORK_NAME="trinity-wp-dev"
export WP_IMAGE="wordpress"
export WP_NAME="wp-plugin-e2e"
export WP_PORT=3080
export DB_USER="root"
export DB_PASS="root"
export DB_NETWORK="conf-db-test"
export DB_SCHEMA_WP="wp"
export SERGIO_URL="http://host.docker.internal:8080" # comment out to use fallback to prod
export TRINITY_URL="http://dev-sas.site/player/trinity/" # comment out to use fallback to prod

docker network create $NETWORK_NAME || true

./scripts/db_conf_clear.sh
./scripts/db_wp_restore.sh

# Override from localhost for WP container
export DB_HOST="conf-db-test"

docker rm -f $WP_NAME | true
./scripts/run_wp.sh

echo "Done successfully"
