#!/bin/bash
set -ex

echo "******************************"
echo " Starting Wordpress"
echo "******************************"

if [[ -n $WP_PORT ]]; then
  EXTRA_PARAM="-p ${WP_PORT}:3080";
fi

docker run -d \
  $EXTRA_PARAM \
  --name $WP_NAME \
  --net $NETWORK_NAME \
  --pull always \
  -e WORDPRESS_DB_HOST=$DB_HOST \
  -e WORDPRESS_DB_NAME=$DB_SCHEMA_WP \
  -e WORDPRESS_DB_USER=$DB_USER \
  -e WORDPRESS_DB_PASSWORD=$DB_PASS \
  -e PLUGIN_AUDIO_SERVICE_URL=$SERGIO_URL \
  -e PLUGIN_TTS_PLAYER_URL=$TRINITY_URL \
  -v "$(pwd)":/var/www/html/wp-content/plugins/trinity \
  $WP_IMAGE

docker network connect $DB_NETWORK $WP_NAME || true

# move wordpress internally to port 3080
docker exec $WP_NAME bash -c "echo 'Listen 3080' >> /etc/apache2/ports.conf"
