#!/bin/bash
set -ex

echo "******************************"
echo " Starting Trinity Dev Sas Server"
echo "******************************"

if [ -z "$GITHUB_TOKEN" ]; then
    GIT_REPO="git@github.com:MemeGlobal/trinity-player.git"
else
    GIT_REPO="https://${GITHUB_TOKEN}@github.com/MemeGlobal/trinity-player.git"
fi

if [ ! -d "../trinity-player" ]; then
  cd ..
  echo "Cloning trinity-player repo with $GIT_REPO"
  git clone --depth 1 $GIT_REPO
else
  echo "Updating trinity-player repo"
  cd ../trinity-player
  git pull origin master
fi

cd -

docker run -d \
  --name $DEV_SAS_NAME \
  --net $NETWORK_NAME \
  --pull always \
  -e REDIS=$REDIS_SLAVE_NAME \
  -e SERGIO=$SERGIO_NAME \
  -v /$(pwd)/../trinity-player/trinity-server/src:/var/www/sas \
  -v "$(pwd)"/../trinity-player/:/var/www/trinity-player/ \
  $DEV_SAS_IMAGE

# installing node and npm
docker exec $DEV_SAS_NAME bash -c "yum install -y nodejs npm"
docker exec $DEV_SAS_NAME bash -c "node --version && npm --version"

# installing deps and building a bundle
docker exec $DEV_SAS_NAME bash -c "cd /var/www/trinity-player/ && npm ci"
docker exec $DEV_SAS_NAME bash -c "cd /var/www/trinity-player/tts-player/ && npm ci && npm run build:modern"

# copying bundle from mounted dir to one level up
docker exec $DEV_SAS_NAME bash -c "mkdir -p /var/www/sas/tts-player/ && cp -r /var/www/trinity-player/tts-player/dist/ /var/www/sas/tts-player/dist/"
