#!/bin/bash
set -ex

echo "******************************"
echo " Starting Sergio"
echo "******************************"

R2V2_API_URL="http://$R2V2_NAME/api/"

if [ -z "$AWS_CREDENTIALS_PATH" ]; then
  AWS_CREDENTIALS_PATH=~/.aws/credentials
fi

docker run -d \
  --net $NETWORK_NAME \
  --name $SERGIO_NAME \
  --pull always \
  -e REDIS=$REDIS_MASTER_NAME \
  -e REDIS_SLAVE=$REDIS_SLAVE_NAME \
  -e R2V2_API_PATH=$R2V2_API_URL \
  -v "$AWS_CREDENTIALS_PATH":/root/.aws/credentials:ro \
  $SERGIO_IMAGE
