#!/bin/bash
set -ex

echo "******************************"
echo " Starting Selenium"
echo "******************************"

MOUNT_POINT=${MOUNT_POINT:-"/tmp/source"}
WP_URL="http://$WP_NAME"
DEV_SAS_IP=$(docker inspect --format='{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}' "${DEV_SAS_NAME}")

docker run -d \
  --cap-add=SYS_ADMIN \
  --name $SELENIUM_NAME \
  --net $NETWORK_NAME \
  --add-host "dev-sas.site:${DEV_SAS_IP}" \
  --add-host "dev-sas-web.site:${DEV_SAS_IP}" \
  --add-host "local-vd.dev-sas.site:${DEV_SAS_IP}" \
  -e START_XVFB=false \
  -e WP_URL=$WP_URL \
  -e REDIS_HOST=$REDIS_MASTER_NAME \
  -v "$(pwd)":"$MOUNT_POINT" \
  $SELENIUM_IMAGE

echo "Installing npm packages..."

docker exec $SELENIUM_NAME bash -c "cd $MOUNT_POINT && npm ci"

# to match image with chrome 99˝
docker exec $SELENIUM_NAME bash -c "cd $MOUNT_POINT && npm i chromedriver@99 -D"

docker exec $SELENIUM_NAME bash -c "cd $MOUNT_POINT && apt update && apt install -y default-mysql-client redis"

echo "Runnint tests..."

docker exec $SELENIUM_NAME bash -c "cd $MOUNT_POINT && DB_HOST=$DB_HOST npm run test-e2e:headless"
