#!/bin/bash
set -ex

echo "******************************"
echo "# Starting conf-db"
echo "******************************"

if [ -z "$GITHUB_TOKEN" ]; then
    GIT_REPO="git@github.com:MemeGlobal/data-stores.git"
else
    GIT_REPO="https://${GITHUB_TOKEN}@github.com/MemeGlobal/data-stores.git"
fi

if [ ! -d "../data-stores" ]; then
  cd ..
  echo "Cloning data-stores repo with $GIT_REPO"
  git clone --depth 1 $GIT_REPO
else
  echo "Updating data-stores scripts"
  cd ../data-stores
  git pull origin master
fi

cd -

cd ../data-stores/conf-db/data/

./updateLocalDB.sh $DB_HOST $DB_PORT

cd -

docker network connect $NETWORK_NAME $DB_HOST || true
