#!/bin/bash

# set -ex

ACTION=${1:-"seed"}
REDIS_HOST=${REDIS_HOST:-"localhost"}
DATASET_PATH="./datasets/redis/${ACTION}"
ACTION_DIRS=`ls $DATASET_PATH**`;

for dir in $ACTION_DIRS; do
  files=`ls $DATASET_PATH/$dir`

  for file in $files; do
    file_path="${DATASET_PATH}/${dir}/${file}"
    file_no_ext="${file%.*}"

    redis-cli -h $REDIS_HOST -x HSET $dir $file_no_ext <$file_path
  done
done
