#!/bin/bash

source ./scripts/db_creds.sh

mysql -h $DB_HOST -u $DB_USER -p$DB_PASS -e "DROP DATABASE IF EXISTS $DB_SCHEMA_WP; CREATE SCHEMA $DB_SCHEMA_WP;"

mysql -h $DB_HOST -u $DB_USER -p$DB_PASS $DB_SCHEMA_WP < ./sql/db_wp_dump.sql

if [[ -n $WP_URL ]]; then
  # Wordpress DB configs domain should match the domain being accessed.
  # Otherwise WP will redirect to the value set in the DB.
  mysql -h $DB_HOST -u $DB_USER -p$DB_PASS $DB_SCHEMA_WP -e "UPDATE wp_options SET option_value = '$WP_URL' WHERE option_name IN ('siteurl', 'home');"
fi
