module.exports = {
  env: {
    browser: true,
    es6: true,
    node: true,
    mocha: true,
    jest: true // removes warning "expect is not defined"
  },
  extends: [
    'airbnb-base'
  ],
  globals: {
    Atomics: 'readonly',
    SharedArrayBuffer: 'readonly',

    google: 'readonly',

    // wdio
    browser: 'readonly',
    $: 'readonly',
    $$: 'readonly'
  },
  parserOptions: {
    ecmaVersion: 2020,
    sourceType: 'module'
  },
  ignorePatterns: [
    'tts-player/tests/datasets'
  ],
  rules: {
    'comma-dangle': ['error', 'never'],
    indent: ['error', 2, {
      SwitchCase: 1
    }],
    'no-multi-spaces': ['error', {
      exceptions: {
        VariableDeclarator: true
      }
    }],
    'one-var-declaration-per-line': ['error', 'always'],
    'one-var': ['error', 'never'],
    'object-curly-spacing': ['error', 'never'],
    'no-inner-declarations': 0,
    'no-async-promise-executor': 0,
    'no-promise-executor-return': 0,
    'no-constructor-return': 0,
    'function-paren-newline': 0,
    'no-unsafe-optional-chaining': 0,
    'import/no-relative-packages': 0,
    'no-return-await': 0,
    'no-plusplus': 0,
    'max-len': [0, 120],
    'no-trailing-spaces': ['error'],
    quotes: ['error', 'single'],
    semi: ['error', 'always'],
    'import/extensions': [0, {
      js: 'always'
    }],
    'import/no-extraneous-dependencies': 0,
    'object-curly-newline': ['error', {
      ObjectExpression: {
        minProperties: 1
      },
      ObjectPattern: {
        multiline: true
      }
    }],
    'object-property-newline': ['error', {
      allowAllPropertiesOnSameLine: false
    }],
    'class-methods-use-this': 0,
    'no-throw-literal': 0,
    'no-use-before-define': 0,
    'no-param-reassign': 0,
    'guard-for-in': 0,
    'no-restricted-syntax': 0,
    'consistent-return': 0,
    'default-case': 0,
    'no-console': 0,
    'no-underscore-dangle': 0,
    'array-callback-return': 0,
    'no-eval': 0,
    curly: 0,
    'prefer-destructuring': 0,
    'no-return-assign': 0,
    'space-before-function-paren': 0,
    'wrap-iife': ['error', 'inside'],
    'no-new': 0,
    'global-require': 0,
    'no-mixed-operators': 0,
    'func-names': 0,
    'import/no-unresolved': 0,
    'prefer-promise-reject-errors': 0,
    'no-continue': 0,
    'no-await-in-loop': 0,
    'import/no-mutable-exports': 0,
    'no-unused-expressions': 0,
    'no-case-declarations': 0
  },
  settings: {
    'import/resolver': {
      node: {
        paths: ['npm'],
        extensions: ['.js', '.jsx', '.ts', '.tsx']
      }
    }
  },
  overrides: [
    {
      files: ['**/tests/**/*.js', '**.spec.js'],
      rules: {
        'no-unused-expressions': 0
      }
    }
  ]
};
